/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DescriptorLayer.h                                                  *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              05/05/2007       1.0                              *
* Carlos Grossy              17/05/2007       1.1                              *
*******************************************************************************/

#ifndef _DESCRIPTORLAYER_H_
#define _DESCRIPTORLAYER_H_

using namespace std;
#include <map>
#include "USBTrans.h"
#include "Log.h"

#if _PLATFORM_LINUX

#ifdef _DRIVER_LIBUSB
    #include "DriverLayerLibUsb.h"
#endif
#ifdef _DRIVER_CUSTOM
#endif

#endif

#if _PLATFORM_WIN32

#ifdef _DRIVER_MICROCHIP
    #include "DriverLayerMCHP.h"
#endif
#ifdef _DRIVER_LIBUSBWIN32
    #include "DriverLayerLibUsbWin32.h"
#endif
#ifdef _DRIVER_CUSTOM
#endif

#endif

typedef struct {
    int dsc;
    usbin tin;
    int buffer;
    int cantAsignados;
} itemIn;

typedef struct {
    int dsc;
    usbout tout;
    int buffer;
    int cantAsignados;
} itemOut;

class descriptorLayer {
    private:
        driverLayer *dl;
        log *l;
        multimap<int,itemIn> dscIn;
        multimap<int,itemOut> dscOut;
        map<int,int> serials;
        int getBufferIn(int, int);
        int getBufferOut(int, int);
        usbin getTypeDscIn(int, int);
        usbout getTypeDscOut(int, int);
    public:
        descriptorLayer();
        ~descriptorLayer();
        int requestDscIn(int, usbin);
        int requestDscOut(int, usbout);
        void freeDscIn(int, int);
        void freeDscOut(int, int);
        int getBoard(int);
        int getSerial(int);
        // Driver
        bool send(int, int, char *, int, int);
        char* receive(int, int, int&, bool&, int);
        int * getU4ABoards(int&);
};

#endif
